@extends('admin.layout.page-app')
@section('page_title', __('label.contest_info'))
@section('tab_title', __('label.contest_info'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">{{__('label.contest_info')}}</h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
						<li class="breadcrumb-item"><a href="{{ route('admin.contests.index') }}">{{__('label.contests')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{__('label.contest_info')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('admin.contests.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.contests')}}</a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<div class="form-row">
					<div class="col-md-9">
						<div class="form-row">
							<div class="col-md-8">
								<div class="form-group">
									<label>{{__('label.name')}}<span class="text-danger">*</span></label>
									<input name="name" type="text" value="{{ $data['name'] }}" class="form-control" placeholder="{{__('label.name_here')}}" readonly>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.entry_fee')}}<span class="text-danger">*</span></label>
									<input name="entry_fee" type="number" value="{{ $data['entry_fee'] }}" class="form-control" min="1" placeholder="{{__('label.entry_fee_here')}}" readonly>
								</div>
							</div>
						</div>
						<div class="form-row">
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.start_date')}}<span class="text-danger">*</span></label>
									<input name="start_date" type="date" value="{{ $data['start_date'] }}" class="form-control" min="{{ date('Y-m-d') }}" readonly>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.end_date')}}<span class="text-danger">*</span></label>
									<input name="end_date" type="date" value="{{ $data['end_date'] }}" class="form-control" min="{{ date('Y-m-d') }}" readonly>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.maximum_participants')}}<span class="text-danger">*</span></label>
									<input name="max_participants" type="number" value="{{ $data['max_participants'] }}" class="form-control" min="1" placeholder="{{__('label.maximum_participants_here')}}" readonly>
								</div>
							</div>
						</div>
						<div class="form-row">
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.user_total_prize')}}<span class="text-danger">*</span></label>
									<input name="total_prize_users" type="number" value="{{ $data['total_prize_users'] }}" class="form-control" min="0" placeholder="{{__('label.user_total_prize_here')}}" readonly>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.total_ranks')}}<span class="text-danger">*</span></label>
									<input name="total_ranks" type="number" value="{{ $data['total_ranks'] }}" class="form-control" min="0" placeholder="{{__('label.total_ranks_here')}}" readonly>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.total_prize_coins')}}<span class="text-danger">*</span></label>
									<input name="total_prize_coins" type="number" value="{{ $data['total_prize_coins'] }}" class="form-control" min="0" placeholder="{{__('label.total_prize_coins_here')}}" readonly>
								</div>
							</div>
						</div>
						<div class="form-row">
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.total_questions')}}<span class="text-danger">*</span></label>
									<input name="total_questions" type="number" value="{{ $data['total_questions'] }}" class="form-control" min="0" placeholder="{{__('label.total_questions_here')}}" readonly>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label>{{__('label.duration_per_question')}}<span class="text-danger">*</span></label>
									<input type="number" name="duration" value="{{ $data['duration'] }}" min="1" class="form-control" placeholder="{{__('label.seconds_here')}}" readonly>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-group ml-5">
							<label>{{__('label.image')}}<span class="text-danger">*</span></label>
							<div class="avatar-upload">
								<div class="avatar-preview">
									<img src="{{ $data['image'] }}">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="card custom-border-card mt-4">
				<div class="card-header">
					<h5 class="mb-0">{{__('label.prize_distribution')}}</h5>
				</div>
				<div class="card-body">
					@if(count($data['json']) > 0)
						<div class="table-responsive">
							<table class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>{{__('label.rank')}}</th>
										<th>{{__('label.winning_coin')}}</th>
										<th>{{__('label.total_users')}}</th>
										<th>{{__('label.total_coin')}}</th>
									</tr>
								</thead>
								<tbody>
									@php
										$totalUsers = 0;
										$totalCoins = 0;
									@endphp

									@foreach($data['json'] as $row)
										<tr>
											<td>{{ $row['rank'] }}</td>
											<td>{{ $row['winning_coin'] }}</td>
											<td>{{ $row['user_count'] }}</td>
											<td>{{ $row['total_coin'] }}</td>
										</tr>
										@php
											$totalUsers += $row['user_count'];
											$totalCoins += $row['total_coin'];
										@endphp
									@endforeach
								</tbody>
								<tfoot>
									<tr>
										<th colspan="2" class="text-right">{{__('label.total')}} : </th>
										<th>{{ $totalUsers }}</th>
										<th>{{ $totalCoins }}<span class="ml-4 text-muted">( {{__('label.expected')}} )</span></th>
									</tr>
								</tfoot>
							</table>
						</div>
					@else
						<h4 class="text-muted">{{__('label.data_not_found')}}</h4>
					@endif
				</div>
			</div>
		</div>
	</div>
@endsection

@section('pagescript')
	<script>
	</script>
@endsection